! only for 320-shot supergather
program lsm2d
include "lsm2d_parameters.par"

! declare the variables
real                :: s(nz,nx),model_refl(nz,nx)
real                :: mig(nz,nx),mig_temp(nz,nx)
real                :: csg_single(ntime,ng)
real                :: csg_true(ntime,ng,ns)
real                :: distance(nz,nx,ns)
real                :: ttt(nz,nx,ns)
double precision    :: a,b                 ! varibale for adjoint test
real                :: source(nsource)     !variable for ricker wavelet mem=4*nsource
integer             :: i1,i2,is,i,j,k!loop variables mem=4*12
character*200       :: filename ! mem=80
character*4         :: pre_fix,sub_fix
character*10        :: date,time_now! mem=10*3

call date_and_time(date,time_now)
write(*,*)date,"  ",time_now
write(*,*)"Model Size :  nx ",nx,"    nz ",nz
write(*,*)"           :  dx ",dx,"    dz ",dz
write(*,*)"Survey Size:  ns ",ns,"    ng ",ng
write(*,*)"           :  ds ",ds,"    dg ",dg
write(*,*)"trace para :  ntime ",ntime," dt ",dt
write(*,*)"peak frequency of ricker wavelet ",fr
write(*,*)"Designed iteration number:       ",nit
call flush(6)
if (ti.eq.1) then
   write(*,*)"Use the true velocity model as background"
elseif (ti.eq.2) then
   write(*,*)"Use the initial background vel model"
else 
   write(*,*)"Incorrect background vel model"
   goto 100
endif
call flush(6)
if (method.eq.1) then
   write(*,*)"Use the Steepest Descent method"
call flush(6)
   elseif (method.eq.2) then
   write(*,*)"Use the Conjugate Gradient method"
   if (reset.lt.nit) then
      write(*,*)"Reset the conjugate direction?      YES"
      write(*,*)"Reset every",reset,"  iterations"
      call flush()
   else
      write(*,*)"Reset the conjugate direction?      NO"
      call flush(6)
   endif
endif

! Read in velocity model
filename="./model/fault_vel.bin"
call read_bin_2d(filename,s,nz,nx)
s=1.0/s ! change the velocity to slowness

! generate traveltime table for forward modeling
call eik2d_dir(s,ttt)
write(6,*)"Read the true travel time table"
call flush(6)

! Read in reflectivity model
filename="./model/fault_refl.bin"
call read_bin_2d(filename,model_refl,nz,nx)

! Generate Source wavelet
call ricker(source) 

! cccccc calculate distance table
call dist_cal(distance)
write(*,*)"distance calculated"
call flush(6)

!cccccc  modeling and migration of model_refl
write(*,*)"modeling of the true model"
call flush(6)

! Used to store the TRUE(OBSERVED) data
csg_true=0.0

! Forward Modeling
do is=1,ns
   csg_single=0.0
   ! use "modeling" subroutine to do modeling for one source
   call modeling(model_refl,csg_single,is,source,ttt,distance)
   csg_true(:,:,is)=csg_single(:,:)
   write(*,*)" Shot ",is," finished"
   call flush(6)
enddo
 
if (ti.eq.1) then
   write(*,*)"Use the true travel time table" 
   call flush(6)
else   
   ttt=0.0
   ! Change the filename to your chosen model
   filename="./model/vel0_nz150_nx645_ft.bin" 
   call read_bin_2d(filename,s,nz,nx)
   s=1.0/s ! change the velocity to slowness

   ! generate traveltime table for forward modeling
   call eik2d_dir(s,ttt)
   write(*,*)"Calculate the traveltime table from initial velocity model"
   call flush(6)
endif   

!  migration of csg_true

mig=0.0
do is=1,ns
   mig_temp=0.0
   csg_single=csg_true(:,:,is)
   ! use "migration" subroutine to do migration for one source
   call migration(mig_temp,csg_single,is,source,ttt,distance)
   write(*,*)"Migration of Shot ",is," Finished"
   call flush(6)
   mig=mig+mig_temp
enddo

!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
! Modify this part for your adjoint test

write(*,*)"Adjointness test"
write(*,*)"(Lm,d)=",a
write(*,*)"(m,LTd)=",b
call flush(6)

!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

! Output the migration image
filename="migration.bin"
call write_bin_2d(filename,mig,nz,nx)
write(*,*)"Output the migration image finished"
call flush(6)

pre_fix="mig_" ! used for making the filename for lsm images
sub_fix=".bin" ! used for making the filename for lsm images

!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
! Modify this part to build your LSM with either SD or CG 
! Method with inexact line search step length


! below two lines are used for output LSM images
! with name of "mig_1.bin" to "mig_30.bin"
!call file_name_maker(filename,pre_fix,i,sub_fix)
!call write_bin_2d(filename,mig,nz,nx)

!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

100  continue
write(*,*)"All finished"
call flush(6)

end program lsm2d
